<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Collection;

use Erlage\Photogram\Data\Dtos\Collection\CollectionDisplayImageDTO;

interface InterfaceCollectionSetter
{
    /**
     * @return static 
     */
    public function setId(string $id);

    /**
     * @return static 
     */
    public function setOwnerUserId(string $ownerUserId);

    /**
     * @return static 
     */
    public function setDisplayTitle(string $displayTitle);

    /**
     * @return static 
     */
    public function setDisplayImage(CollectionDisplayImageDTO $displayImage);

    /**
     * @return static 
     */
    public function setStampRegistration(string $stampRegistration);

    /**
     * @return static 
     */
    public function setStampLastUpdate(string $stampLastUpdate);
}
